#!/usr/bin/env bash

set -ex



if [[ -d Evilectron.app ]]; then
    echo "Evilectron.app already exists, nothing to do."
    exit
fi



echo "Prepare files for Evilectron?"
select yn in "Continue" "Exit"; do
    case $yn in
        Continue ) break;;
        Exit ) exit;;
    esac
done



if [[ $(uname -s) = MINGW64* ]]; then
    rm -f *.bin *.dat *.json *.pak *.so evilectron
    rm -f swiftshader/*.so
    unzip -o resources/win32.zip
fi



if [[ $(uname -s) = Linux* ]]; then
    rm -f *.bin *.dat *.dll *.exe *.json *.pak
    rm -f swiftshader/*.dll
    unzip -o resources/linux.zip
    chmod u+x evilectron
fi



if [[ $(uname -s) = Darwin* ]]; then
    rm -f *.bin *.dat *.dll *.exe *.json *.pak *.so evilectron
    unzip resources/darwin.zip
    cp -R resources/* Evilectron.app/Contents/Resources
fi
